/*********************************************************************
 *
 * Copyright:
 *	1999-2000 MOTOROLA, INC. All Rights Reserved.  
 *  You are hereby granted a copyright license to use, modify, and
 *  distribute the SOFTWARE so long as this entire notice is
 *  retained without alteration in any modified and/or redistributed
 *  versions, and that such modified versions are clearly identified
 *  as such. No licenses are granted by implication, estoppel or
 *  otherwise under any patents or trademarks of Motorola, Inc. This 
 *  software is provided on an "AS IS" basis and without warranty.
 *
 *  To the maximum extent permitted by applicable law, MOTOROLA 
 *  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
 *  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 *  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
 *  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
 *  ACCOMPANYING WRITTEN MATERIALS.
 * 
 *  To the maximum extent permitted by applicable law, IN NO EVENT
 *  SHALL MOTOROLA BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
 *  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
 *  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
 *  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
 * 
 *  Motorola assumes no responsibility for the maintenance and support
 *  of this software
 ********************************************************************/

/*
 * File:	vectors.s
 * Purpose:	vector table for mcf5xxx
 *
 *
 * Modifications:
 *
 */

#ifndef _UNDERSCORE_
#define _asm_startmeup			asm_startmeup
#define _asm_exception_handler	asm_exception_handler
#define _irq_handler			irq_handler
#endif

	.global VECTOR_TABLE
	.global _VECTOR_TABLE
	.global start

	.extern ___SP_INIT
	.extern _asm_startmeup
	.extern _asm_exception_handler
	.extern _irq_handler

	.text

/********************************************************************/
/* Exception Vector Table */
/********************************************************************/

VECTOR_TABLE:
_VECTOR_TABLE:

INITSP:		.long	___SP_INIT					/* Initial SP			*/
INITPC:		.long	_asm_startmeup				/* Initial PC			*/
vector02:	.long	_asm_exception_handler		/* Access Error			*/
vector03:	.long	_asm_exception_handler		/* Address Error		*/
vector04:	.long	_asm_exception_handler		/* Illegal Instruction	*/
vector05:	.long	_asm_exception_handler		/* Reserved				*/
vector06:	.long	_asm_exception_handler		/* Reserved				*/
vector07:	.long	_asm_exception_handler		/* Reserved				*/
vector08:	.long	_asm_exception_handler		/* Privilege Violation	*/
vector09:	.long	_asm_exception_handler		/* Trace				*/
vector0A:	.long	_asm_exception_handler		/* Unimplemented A-Line	*/
vector0B:	.long	_asm_exception_handler		/* Unimplemented F-Line	*/
vector0C:	.long	_asm_exception_handler		/* Debug Interrupt		*/
vector0D:	.long	_asm_exception_handler		/* Reserved				*/
vector0E:	.long	_asm_exception_handler		/* Format Error			*/
vector0F:	.long	_asm_exception_handler		/* Unitialized Int.		*/
vector10:	.long	_asm_exception_handler		/* Reserved				*/
vector11:	.long	_asm_exception_handler		/* Reserved				*/
vector12:	.long	_asm_exception_handler		/* Reserved				*/
vector13:	.long	_asm_exception_handler		/* Reserved				*/
vector14:	.long	_asm_exception_handler		/* Reserved				*/
vector15:	.long	_asm_exception_handler		/* Reserved				*/
vector16:	.long	_asm_exception_handler		/* Reserved				*/
vector17:	.long	_asm_exception_handler		/* Reserved				*/
vector18:	.long	_asm_exception_handler		/* Spurious Interrupt	*/
vector19:	.long	_asm_exception_handler		/* Autovector Level 1	*/
vector1A:	.long	_asm_exception_handler		/* Autovector Level 2	*/
vector1B:	.long	_asm_exception_handler		/* Autovector Level 3	*/
vector1C:	.long	_asm_exception_handler		/* Autovector Level 4	*/
vector1D:	.long	_asm_exception_handler		/* Autovector Level 5	*/
vector1E:	.long	_asm_exception_handler		/* Autovector Level 6	*/
vector1F:	.long	_asm_exception_handler		/* Autovector Level 7	*/
vector20:	.long	_asm_exception_handler		/* TRAP #0				*/
vector21:	.long	_asm_exception_handler		/* TRAP #1				*/
vector22:	.long	_asm_exception_handler		/* TRAP #2				*/
vector23:	.long	_asm_exception_handler		/* TRAP #3				*/
vector24:	.long	_asm_exception_handler		/* TRAP #4				*/
vector25:	.long	_asm_exception_handler		/* TRAP #5				*/
vector26:	.long	_asm_exception_handler		/* TRAP #6				*/
vector27:	.long	_asm_exception_handler		/* TRAP #7				*/
vector28:	.long	_asm_exception_handler		/* TRAP #8				*/
vector29:	.long	_asm_exception_handler		/* TRAP #9				*/
vector2A:	.long	_asm_exception_handler		/* TRAP #10				*/
vector2B:	.long	_asm_exception_handler		/* TRAP #11				*/
vector2C:	.long	_asm_exception_handler		/* TRAP #12				*/
vector2D:	.long	_asm_exception_handler		/* TRAP #13				*/
vector2E:	.long	_asm_exception_handler		/* TRAP #14				*/
vector2F:	.long	_asm_exception_handler		/* TRAP #15				*/
vector30:	.long	_asm_exception_handler		/* Reserved				*/
vector31:	.long	_asm_exception_handler		/* Reserved				*/
vector32:	.long	_asm_exception_handler		/* Reserved				*/
vector33:	.long	_asm_exception_handler		/* Reserved				*/
vector34:	.long	_asm_exception_handler		/* Reserved				*/
vector35:	.long	_asm_exception_handler		/* Reserved				*/
vector36:	.long	_asm_exception_handler		/* Reserved				*/
vector37:	.long	_asm_exception_handler		/* Reserved				*/
vector38:	.long	_asm_exception_handler		/* Reserved				*/
vector39:	.long	_asm_exception_handler		/* Reserved				*/
vector3A:	.long	_asm_exception_handler		/* Reserved				*/
vector3B:	.long	_asm_exception_handler		/* Reserved				*/
vector3C:	.long	_asm_exception_handler		/* Reserved				*/
vector3D:	.long	_asm_exception_handler		/* Reserved				*/
vector3E:	.long	_asm_exception_handler		/* Reserved				*/
vector3F:	.long	_asm_exception_handler		/* Reserved				*/
vector40:	.long	_asm_exception_handler		/* User Defined Int.	*/
vector41:	.long	_asm_exception_handler
vector42:	.long	_asm_exception_handler
vector43:	.long	_asm_exception_handler
vector44:	.long	_asm_exception_handler
vector45:	.long	_asm_exception_handler
vector46:	.long	_asm_exception_handler
vector47:	.long	_asm_exception_handler
vector48:	.long	_asm_exception_handler
vector49:	.long	_asm_exception_handler
vector4A:	.long	_asm_exception_handler
vector4B:	.long	_asm_exception_handler
vector4C:	.long	_asm_exception_handler
vector4D:	.long	_asm_exception_handler
vector4E:	.long	_asm_exception_handler
vector4F:	.long	_asm_exception_handler
vector50:	.long	_asm_exception_handler
vector51:	.long	_asm_exception_handler
vector52:	.long	_asm_exception_handler
vector53:	.long	_asm_exception_handler
vector54:	.long	_asm_exception_handler
vector55:	.long	_asm_exception_handler
vector56:	.long	_asm_exception_handler
vector57:	.long	_asm_exception_handler
vector58:	.long	_asm_exception_handler
vector59:	.long	_asm_exception_handler
vector5A:	.long	_asm_exception_handler
vector5B:	.long	_asm_exception_handler
vector5C:	.long	_asm_exception_handler
vector5D:	.long	_asm_exception_handler
vector5E:	.long	_asm_exception_handler
vector5F:	.long	_asm_exception_handler
vector60:	.long	_asm_exception_handler
vector61:	.long	_asm_exception_handler
vector62:	.long	_asm_exception_handler
vector63:	.long	_asm_exception_handler
vector64:	.long	_asm_exception_handler
vector65:	.long	_asm_exception_handler
vector66:	.long	_asm_exception_handler
vector67:	.long	_asm_exception_handler
vector68:	.long	_asm_exception_handler
vector69:	.long	_asm_exception_handler
vector6A:	.long	_asm_exception_handler
vector6B:	.long	_asm_exception_handler
vector6C:	.long	_asm_exception_handler
vector6D:	.long	_asm_exception_handler
vector6E:	.long	_asm_exception_handler
vector6F:	.long	_asm_exception_handler
vector70:	.long	_asm_exception_handler
vector71:	.long	_asm_exception_handler
vector72:	.long	_asm_exception_handler
vector73:	.long	_asm_exception_handler
vector74:	.long	_asm_exception_handler
vector75:	.long	_asm_exception_handler
vector76:	.long	_asm_exception_handler
vector77:	.long	_asm_exception_handler
vector78:	.long	_asm_exception_handler
vector79:	.long	_asm_exception_handler
vector7A:	.long	_asm_exception_handler
vector7B:	.long	_asm_exception_handler
vector7C:	.long	_asm_exception_handler
vector7D:	.long	_asm_exception_handler
vector7E:	.long	_asm_exception_handler
vector7F:	.long	_asm_exception_handler
vector80:	.long	_asm_exception_handler
vector81:	.long	_asm_exception_handler
vector82:	.long	_asm_exception_handler
vector83:	.long	_asm_exception_handler
vector84:	.long	_asm_exception_handler
vector85:	.long	_asm_exception_handler
vector86:	.long	_asm_exception_handler
vector87:	.long	_asm_exception_handler
vector88:	.long	_asm_exception_handler
vector89:	.long	_asm_exception_handler
vector8A:	.long	_asm_exception_handler
vector8B:	.long	_asm_exception_handler
vector8C:	.long	_asm_exception_handler
vector8D:	.long	_asm_exception_handler
vector8E:	.long	_asm_exception_handler
vector8F:	.long	_asm_exception_handler
vector90:	.long	_asm_exception_handler
vector91:	.long	_asm_exception_handler
vector92:	.long	_asm_exception_handler
vector93:	.long	_asm_exception_handler
vector94:	.long	_asm_exception_handler
vector95:	.long	_asm_exception_handler
vector96:	.long	_asm_exception_handler
vector97:	.long	_asm_exception_handler
vector98:	.long	_asm_exception_handler
vector99:	.long	_asm_exception_handler
vector9A:	.long	_asm_exception_handler
vector9B:	.long	_asm_exception_handler
vector9C:	.long	_asm_exception_handler
vector9D:	.long	_asm_exception_handler
vector9E:	.long	_asm_exception_handler
vector9F:	.long	_asm_exception_handler
vectorA0:	.long	_asm_exception_handler
vectorA1:	.long	_asm_exception_handler
vectorA2:	.long	_asm_exception_handler
vectorA3:	.long	_asm_exception_handler
vectorA4:	.long	_asm_exception_handler
vectorA5:	.long	_asm_exception_handler
vectorA6:	.long	_asm_exception_handler
vectorA7:	.long	_asm_exception_handler
vectorA8:	.long	_asm_exception_handler
vectorA9:	.long	_asm_exception_handler
vectorAA:	.long	_asm_exception_handler
vectorAB:	.long	_asm_exception_handler
vectorAC:	.long	_asm_exception_handler
vectorAD:	.long	_asm_exception_handler
vectorAE:	.long	_asm_exception_handler
vectorAF:	.long	_asm_exception_handler
vectorB0:	.long	_asm_exception_handler
vectorB1:	.long	_asm_exception_handler
vectorB2:	.long	_asm_exception_handler
vectorB3:	.long	_asm_exception_handler
vectorB4:	.long	_asm_exception_handler
vectorB5:	.long	_asm_exception_handler
vectorB6:	.long	_asm_exception_handler
vectorB7:	.long	_asm_exception_handler
vectorB8:	.long	_asm_exception_handler
vectorB9:	.long	_asm_exception_handler
vectorBA:	.long	_asm_exception_handler
vectorBB:	.long	_asm_exception_handler
vectorBC:	.long	_asm_exception_handler
vectorBD:	.long	_asm_exception_handler
vectorBE:	.long	_asm_exception_handler
vectorBF:	.long	_asm_exception_handler
vectorC0:	.long	_asm_exception_handler
vectorC1:	.long	_asm_exception_handler
vectorC2:	.long	_asm_exception_handler
vectorC3:	.long	_asm_exception_handler
vectorC4:	.long	_asm_exception_handler
vectorC5:	.long	_asm_exception_handler
vectorC6:	.long	_asm_exception_handler
vectorC7:	.long	_asm_exception_handler
vectorC8:	.long	_asm_exception_handler
vectorC9:	.long	_asm_exception_handler
vectorCA:	.long	_asm_exception_handler
vectorCB:	.long	_asm_exception_handler
vectorCC:	.long	_asm_exception_handler
vectorCD:	.long	_asm_exception_handler
vectorCE:	.long	_asm_exception_handler
vectorCF:	.long	_asm_exception_handler
vectorD0:	.long	_asm_exception_handler
vectorD1:	.long	_asm_exception_handler
vectorD2:	.long	_asm_exception_handler
vectorD3:	.long	_asm_exception_handler
vectorD4:	.long	_asm_exception_handler
vectorD5:	.long	_asm_exception_handler
vectorD6:	.long	_asm_exception_handler
vectorD7:	.long	_asm_exception_handler
vectorD8:	.long	_asm_exception_handler
vectorD9:	.long	_asm_exception_handler
vectorDA:	.long	_asm_exception_handler
vectorDB:	.long	_asm_exception_handler
vectorDC:	.long	_asm_exception_handler
vectorDD:	.long	_asm_exception_handler
vectorDE:	.long	_asm_exception_handler
vectorDF:	.long	_asm_exception_handler
vectorE0:	.long	_asm_exception_handler
vectorE1:	.long	_asm_exception_handler
vectorE2:	.long	_asm_exception_handler
vectorE3:	.long	_asm_exception_handler
vectorE4:	.long	_asm_exception_handler
vectorE5:	.long	_asm_exception_handler
vectorE6:	.long	_asm_exception_handler
vectorE7:	.long	_asm_exception_handler
vectorE8:	.long	_asm_exception_handler
vectorE9:	.long	_asm_exception_handler
vectorEA:	.long	_asm_exception_handler
vectorEB:	.long	_asm_exception_handler
vectorEC:	.long	_asm_exception_handler
vectorED:	.long	_asm_exception_handler
vectorEE:	.long	_asm_exception_handler
vectorEF:	.long	_asm_exception_handler
vectorF0:	.long	_asm_exception_handler
vectorF1:	.long	_asm_exception_handler
vectorF2:	.long	_asm_exception_handler
vectorF3:	.long	_asm_exception_handler
vectorF4:	.long	_asm_exception_handler
vectorF5:	.long	_asm_exception_handler
vectorF6:	.long	_asm_exception_handler
vectorF7:	.long	_asm_exception_handler
vectorF8:	.long	_asm_exception_handler
vectorF9:	.long	_asm_exception_handler
vectorFA:	.long	_asm_exception_handler
vectorFB:	.long	_asm_exception_handler
vectorFC:	.long	_asm_exception_handler
vectorFD:	.long	_asm_exception_handler
vectorFE:	.long	_asm_exception_handler
vectorFF:	.long	_asm_exception_handler

/* offsets 0x400 - 0x417 in CFM */
CFMWords:
			.long	0 /* back door comparison key hi */
			.long 	0 /* back door comparison key lo */
			.long 	0 /* CFMPROT */		
			.long 	0 /* CFMSACC */
			.long 	0 /* CFMDACC */
			.long 	0 /* CFMSEC */
			
.end
